--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--
rollout DYNatmosphere ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCfog
  local LOCspinStartValue
  local LOCundoState = on

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNsetupFogParams FUNfog =
  (
    DYNatmosphere.CBATMonOff.checked = isActive FUNfog
    DYNatmosphere.COATMcolor.color   = FUNfog.fog_color
    DYNatmosphere.SPATMnear.value    = FUNfog.near
    DYNatmosphere.SPATMfar.value     = FUNfog.far

    if FUNfog.fog_type == 1 then
    (
      DYNatmosphere.SPATMnear.enabled = false
      DYNatmosphere.SPATMfar.enabled = false
    )
    else
    (
      DYNatmosphere.SPATMnear.enabled = true
      DYNatmosphere.SPATMfar.enabled = true
    )
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  checkbox    CBATMonoff    align:#left pos:[4,9]
  groupbox    GBATMgroup01  width:(DYNiniExplorerWidth - 21) height:56 pos:[4,31]
  colorpicker COATMcolor "" fieldwidth:(DYNiniExplorerWidth - 39) height:25 pos:[8,52]

  groupbox    GBATMgroup02  width:(DYNiniExplorerWidth - 21) height:70 pos:[4,93]
  spinner     SPATMnear     type:#float fieldwidth:60 range:[0,100,0]   scale:0.1 align:#left pos:[(DYNiniExplorerWidth - 96),113]
  spinner     SPATMfar      type:#float fieldwidth:60 range:[0,100,100] scale:0.1 align:#left pos:[(DYNiniExplorerWidth - 96),134]
  label       LBATMnear     width:95 align:#left pos:[13,116]
  label       LBATMfar      width:95 align:#left pos:[13,137]

  button      BUATMreset    width:(DYNiniExplorerWidth - 21) pos:[4,171]
  button      BUATMadvanced width:(DYNiniExplorerWidth - 21) pos:[4,196]

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNatmosphere open do
  (
    DYNatmosphere.title = DYNuiRolloutNames[4]
    GBATMgroup01.text   = DYNuiResourcesGroups[4]
    GBATMgroup02.text   = DYNuiResourcesGroups[3]
    BUATMreset.text     = DYNuiResourcesButtons[13]
    BUATMadvanced.text  = DYNuiResourcesButtons[28]
    CBATMonOff.text     = DYNuiResourcesLabels[22]
    LBATMnear.text      = DYNuiResourcesLabels[23]
    LBATMfar.text       = DYNuiResourcesLabels[24]

    if numAtmospherics > 0 then
    (
      for i = 1 to numAtmospherics do
      (
        if (getAtmospheric i).name == DYNfogName then LOCfog = getAtmospheric i
      )
      if LOCfog == undefined then
      (
        LOCfog = fog()
        addAtmospheric LOCfog
        DYNFUNresetFogParams LOCfog
      )
    )
    else
    (
      LOCfog = fog()
      addAtmospheric LOCfog
      DYNFUNresetFogParams LOCfog
    )
    DYNFUNsetupFogParams LOCfog
    if (isActive LOCfog) == false then DYNamite.dnAtmosNode.forecolor = DYNFUNdnColor (DYNINIgreyedOutColor) else DYNamite.dnAtmosNode.forecolor = DYNFUNdnColor (((colorMan.getColor #text) as color) * 255)
  )

  on COATMcolor changed val do LOCfog.fog_color = val

  --- Spinner Near Fog Control
  on SPATMnear changed arg do (with undo label:DYNuiResourcesUndoLabels[1] LOCundoState LOCfog.near = arg)
  on SPATMnear buttonDown  do (LOCundoState = off; LOCspinStartValue = SPATMnear.value)
  on SPATMnear buttonUp    do
  (
    if LOCspinStartValue != SPATMnear.value then
    (
      with undo off LOCfog.near = LOCspinStartValue
      with undo label:DYNuiResourcesUndoLabels[1] on LOCfog.near = SPATMnear.value
    )
    LOCundoState = on
  )


  --- Spinner Far Fog Control
  on SPATMfar changed arg do (with undo label:DYNuiResourcesUndoLabels[1] LOCundoState LOCfog.far = arg)
  on SPATMfar buttonDown  do (LOCundoState = off; LOCspinStartValue = SPATMfar.value)
  on SPATMfar buttonUp    do
  (
    if LOCspinStartValue != SPATMfar.value then
    (
      with undo off LOCfog.far = LOCspinStartValue
      with undo label:DYNuiResourcesUndoLabels[1] on (LOCfog.far = SPATMfar.value)
    )
    LOCundoState = on
  )

  on CBATMonOff changed val do
  (
    setActive LOCfog val
    if (isActive LOCfog) == false then DYNamite.dnAtmosNode.forecolor = DYNFUNdnColor (DYNINIgreyedOutColor) else DYNamite.dnAtmosNode.forecolor = DYNFUNdnColor (((colorMan.getColor #text) as color) * 255)
  )

  on BUATMreset pressed do
  (
    DYNFUNresetFogParams LOCfog
    DYNFUNsetupFogParams LOCfog
  )

  on BUATMadvanced pressed do
  (
    editatmospheric LOCfog
  )
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQA90WZARUgmBNrRCjUVu/FlvSoFSGtjjwQJ
-- +Pt3kr2jP5p42O11/YcpNuIS3Qqfx8zLZ7OZJ6yzVEGLbhGDBWbmuctkyNSbwi9s
-- Rouy4h2IvkzLs9bXzRZwt+pXGi5d6JpuB8raKG2J6PMlTSbny5XxXM0AJ6DJKzjW
-- 9C0oTZHVnaDBWfKTHKYcv2Y4od3JoSKWQlMeSLlmfa0HtPH2O25ZFr1iRSdFyuL8
-- +/1E8sOk+fRn4Z4tOMRv+cbwUF+2sy9B8XkDH/WZGYOwTrboYoNwhFCuUkYdDDaF
-- aj6/6De1w7JgFPgOuKgSIkPwnCE8kkeLRu/umS4YI2MZCJGBUHSq
-- -----END-SIGNATURE-----